/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.security.MessageDigest;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Random;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Clock;
import jpcsp.Emulator;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.SystemTimeManager;
import jpcsp.State;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

@HLELogging
public class UtilsForUser
extends HLEModule {
    public static Logger log = Modules.getLogger("UtilsForUser");
    private HashMap<Integer, SceKernelUtilsMt19937Context> Mt19937List;
    private SceKernelUtilsMd5Context md5Ctx;
    private SceKernelUtilsSha1Context sha1Ctx;
    protected static final int PSP_KERNEL_ICACHE_PROBE_MISS = 0;
    protected static final int PSP_KERNEL_ICACHE_PROBE_HIT = 1;
    protected static final int PSP_KERNEL_DCACHE_PROBE_MISS = 0;
    protected static final int PSP_KERNEL_DCACHE_PROBE_HIT = 1;
    protected static final int PSP_KERNEL_DCACHE_PROBE_HIT_DIRTY = 2;

    @Override
    public void start() {
        this.Mt19937List = new HashMap();
        super.start();
    }

    @HLELogging(level="trace")
    @HLEFunction(nid=-1079410590, version=150)
    public int sceKernelDcacheInvalidateRange(TPointer addr, int size) {
        return 0;
    }

    @HLEFunction(nid=-1025542386, version=150)
    public int sceKernelIcacheInvalidateRange(TPointer addr, int size) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("sceKernelIcacheInvalidateRange addr=%s, size=%d", addr, size));
        }
        RuntimeContext.invalidateRange(addr.getAddress(), size);
        return 0;
    }

    @HLEFunction(nid=-937924008, version=150)
    public int sceKernelUtilsMd5Digest(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer inAddr, int inSize, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.out) TPointer outAddr) {
        int result = SceKernelUtilsMd5Context.digest(inAddr, inSize, outAddr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelUtilsMd5Digest input:%s, output:%s", Utilities.getMemoryDump(inAddr.getAddress(), inSize), Utilities.getMemoryDump(outAddr.getAddress(), 16)));
        }
        return result;
    }

    @HLEFunction(nid=-1638117242, version=150)
    public int sceKernelUtilsMd5BlockInit(TPointer md5CtxAddr) {
        this.md5Ctx = new SceKernelUtilsMd5Context();
        return this.md5Ctx.init(md5CtxAddr);
    }

    @HLEFunction(nid=1642194213, version=150)
    public int sceKernelUtilsMd5BlockUpdate(TPointer md5CtxAddr, TPointer inAddr, int inSize) {
        return this.md5Ctx.update(md5CtxAddr, inAddr, inSize);
    }

    @HLEFunction(nid=-1194176904, version=150)
    public int sceKernelUtilsMd5BlockResult(TPointer md5CtxAddr, TPointer outAddr) {
        return this.md5Ctx.result(md5CtxAddr, outAddr);
    }

    @HLEFunction(nid=-2080220687, version=150)
    public int sceKernelUtilsSha1Digest(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer inAddr, int inSize, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=20, usage=BufferInfo.Usage.out) TPointer outAddr) {
        return SceKernelUtilsSha1Context.digest(inAddr, inSize, outAddr);
    }

    @HLEFunction(nid=-117647942, version=150)
    public int sceKernelUtilsSha1BlockInit(TPointer sha1CtxAddr) {
        this.sha1Ctx = new SceKernelUtilsSha1Context();
        return this.sha1Ctx.init(sha1CtxAddr);
    }

    @HLEFunction(nid=879717800, version=150)
    public int sceKernelUtilsSha1BlockUpdate(TPointer sha1CtxAddr, TPointer inAddr, int inSize) {
        return this.sha1Ctx.update(sha1CtxAddr, inAddr, inSize);
    }

    @HLEFunction(nid=1482628105, version=150)
    public int sceKernelUtilsSha1BlockResult(TPointer sha1CtxAddr, TPointer outAddr) {
        return this.sha1Ctx.result(sha1CtxAddr, outAddr);
    }

    @HLEFunction(nid=-396302498, version=150)
    public int sceKernelUtilsMt19937Init(TPointer ctxAddr, int seed) {
        this.Mt19937List.remove(ctxAddr.getAddress());
        this.Mt19937List.put(ctxAddr.getAddress(), new SceKernelUtilsMt19937Context(ctxAddr, seed));
        return 0;
    }

    @HLEFunction(nid=117148259, version=150)
    public int sceKernelUtilsMt19937UInt(TPointer ctxAddr) {
        SceKernelUtilsMt19937Context ctx = this.Mt19937List.get(ctxAddr.getAddress());
        if (ctx == null) {
            log.warn((Object)String.format("sceKernelUtilsMt19937UInt uninitialised context %s", ctxAddr));
            return 0;
        }
        return ctx.getInt(ctxAddr);
    }

    @HLEFunction(nid=939220034, version=150)
    public int sceKernelGetGPI() {
        int gpi;
        if (State.debugger != null) {
            gpi = State.debugger.GetGPI();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceKernelGetGPI returning 0x%02X", gpi));
            }
        } else {
            gpi = 0;
            if (log.isDebugEnabled()) {
                log.debug((Object)"sceKernelGetGPI debugger not enabled");
            }
        }
        return gpi;
    }

    @HLEFunction(nid=1792230871, version=150)
    public int sceKernelSetGPO(int value) {
        if (State.debugger != null) {
            State.debugger.SetGPO(value);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"sceKernelSetGPO debugger not enabled");
        }
        return 0;
    }

    @HLEFunction(nid=-1847265625, version=150)
    public int sceKernelLibcClock() {
        return (int)SystemTimeManager.getSystemTime();
    }

    @HLEFunction(nid=667703280, version=150)
    public int sceKernelLibcTime(@CanBeNull TPointer32 time_t_addr) {
        int seconds = (int)(Calendar.getInstance().getTimeInMillis() / 1000L);
        time_t_addr.setValue(seconds);
        return seconds;
    }

    @HLEFunction(nid=1911308913, version=150)
    public int sceKernelLibcGettimeofday(@CanBeNull TPointer32 tp, @CanBeNull TPointer32 tzp) {
        Clock.TimeNanos currentTimeNano = Emulator.getClock().currentTimeNanos();
        int tv_sec = currentTimeNano.seconds;
        int tv_usec = currentTimeNano.millis * 1000 + currentTimeNano.micros;
        tp.setValue(0, tv_sec);
        tp.setValue(4, tv_usec);
        int tz_minuteswest = 0;
        int tz_dsttime = 0;
        tzp.setValue(0, tz_minuteswest);
        tzp.setValue(4, tz_dsttime);
        return 0;
    }

    @HLELogging(level="trace")
    @HLEFunction(nid=2043790330, version=150)
    public void sceKernelDcacheWritebackAll() {
    }

    @HLELogging(level="trace")
    @HLEFunction(nid=-1271537979, version=150)
    public void sceKernelDcacheWritebackInvalidateAll() {
    }

    @HLELogging(level="trace")
    @HLEFunction(nid=1055066145, version=150)
    public int sceKernelDcacheWritebackRange(TPointer addr, int size) {
        return 0;
    }

    @HLELogging(level="trace")
    @HLEFunction(nid=884603550, version=150)
    public void sceKernelDcacheWritebackInvalidateRange(TPointer addr, int size) {
    }

    @HLELogging(level="trace")
    @HLEFunction(nid=-2147476404, version=150)
    public int sceKernelDcacheProbe(TPointer addr) {
        return 1;
    }

    @HLEUnimplemented
    @HLEFunction(nid=375659888, version=150)
    public int sceKernelDcacheReadTag() {
        return 0;
    }

    @HLEFunction(nid=-1844506550, version=150)
    public void sceKernelIcacheInvalidateAll() {
        RuntimeContext.invalidateAll();
    }

    @HLELogging(level="trace")
    @HLEFunction(nid=1339235485, version=150)
    public int sceKernelIcacheProbe(TPointer addr) {
        return 1;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-83494192, version=150)
    public void sceKernelIcacheReadTag() {
    }

    private static class SceKernelUtilsSha1Context
    extends SceKernelUtilsContext {
        private static final String algorithm = "SHA-1";

        public SceKernelUtilsSha1Context() {
            super(algorithm, 20);
        }

        public static int digest(TPointer inAddr, int inSize, TPointer outAddr) {
            return SceKernelUtilsSha1Context.digest(inAddr, inSize, outAddr, algorithm, 20);
        }
    }

    private static class SceKernelUtilsMd5Context
    extends SceKernelUtilsContext {
        private static final String algorithm = "MD5";

        public SceKernelUtilsMd5Context() {
            super(algorithm, 16);
        }

        public static int digest(TPointer inAddr, int inSize, TPointer outAddr) {
            return SceKernelUtilsMd5Context.digest(inAddr, inSize, outAddr, algorithm, 16);
        }
    }

    private static class SceKernelUtilsContext {
        private final String algorithm;
        private final int hashLength;
        private int part1;
        private int part2;
        private int part3;
        private int part4;
        private int part5;
        private short tmpBytesRemaining;
        private short tmpBytesCalculated;
        private long fullDataSize;
        private final byte[] buf;
        private byte[] input;

        protected SceKernelUtilsContext(String algorithm, int hashLength) {
            this.algorithm = algorithm;
            this.hashLength = hashLength;
            this.part1 = 0;
            this.part2 = 0;
            this.part3 = 0;
            this.part4 = 0;
            this.part5 = 0;
            this.tmpBytesRemaining = 0;
            this.tmpBytesCalculated = 0;
            this.fullDataSize = 0L;
            this.buf = new byte[64];
        }

        public int init(TPointer ctxAddr) {
            ctxAddr.setValue32(0, this.part1);
            ctxAddr.setValue32(4, this.part2);
            ctxAddr.setValue32(8, this.part3);
            ctxAddr.setValue32(12, this.part4);
            ctxAddr.setValue32(16, this.part5);
            ctxAddr.setValue16(20, this.tmpBytesRemaining);
            ctxAddr.setValue16(22, this.tmpBytesCalculated);
            ctxAddr.setValue64(24, this.fullDataSize);
            ctxAddr.setArray(32, this.buf);
            return 0;
        }

        public int update(TPointer ctxAddr, TPointer dataAddr, int dataSize) {
            this.input = dataAddr.getArray8(dataSize);
            return 0;
        }

        public int result(TPointer ctxAddr, TPointer resultAddr) {
            byte[] hash = null;
            if (this.input != null) {
                try {
                    MessageDigest md = MessageDigest.getInstance(this.algorithm);
                    hash = md.digest(this.input);
                }
                catch (Exception e) {
                    log.warn((Object)String.format("SceKernelUtilsContext(%s).result", this.algorithm), (Throwable)e);
                }
            }
            if (hash != null) {
                resultAddr.setArray(hash, this.hashLength);
            }
            return 0;
        }

        protected static int digest(TPointer inAddr, int inSize, TPointer outAddr, String algorithm, int hashLength) {
            byte[] input = inAddr.getArray8(inSize);
            byte[] hash = null;
            try {
                MessageDigest md = MessageDigest.getInstance(algorithm);
                hash = md.digest(input);
            }
            catch (Exception e) {
                log.warn((Object)String.format("SceKernelUtilsContext(%s).digest", algorithm), (Throwable)e);
            }
            if (hash != null) {
                outAddr.setArray(hash, hashLength);
            }
            return 0;
        }
    }

    private static class SceKernelUtilsMt19937Context {
        private Random r;

        public SceKernelUtilsMt19937Context(TPointer ctxAddr, int seed) {
            this.r = new Random(seed);
            ctxAddr.memset((byte)-51, 628);
        }

        public int getInt(TPointer ctxAddr) {
            return this.r.nextInt();
        }
    }
}

